/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;
import org2.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;

public class DBGpStackFrame
extends DBGpElement
implements IStackFrame {
    private DBGpThread owningThread;
    private String qualifiedFile = "";
    private String stackLevel;
    private String fileName;
    private int lineNo;
    private String name = "";

    public DBGpStackFrame(DBGpThread threadOwner, Node stackData) {
        super(threadOwner.getDebugTarget());
        this.owningThread = threadOwner;
        String line = DBGpResponse.getAttribute(stackData, "lineno");
        this.stackLevel = DBGpResponse.getAttribute(stackData, "level");
        this.lineNo = Integer.parseInt(line);
        this.qualifiedFile = DBGpUtils.getFilenameFromURIString(DBGpResponse.getAttribute(stackData, "filename"));
        this.qualifiedFile = ((DBGpTarget)this.getDebugTarget()).mapToWorkspaceFileIfRequired(this.qualifiedFile);
        IFile[] fileFound = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(this.qualifiedFile));
        String whereAndLine = String.valueOf(DBGpResponse.getAttribute(stackData, "where")) + " : " + PHPDebugCoreMessages.XDebug_DBGpStackFrame_0 + " " + this.lineNo;
        if (fileFound.length > 0) {
            IFile file = fileFound[0];
            this.fileName = file.getProjectRelativePath().toString();
            this.name = String.valueOf(this.fileName) + "." + whereAndLine;
        } else {
            this.fileName = null;
            this.name = String.valueOf(this.qualifiedFile) + "." + whereAndLine;
        }
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        DBGpLogger.debug(String.valueOf(this.hashCode()) + "::DBGpStackFrame=" + this.lineNo);
        return this.lineNo;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.owningThread;
    }

    public IVariable[] getVariables() throws DebugException {
        DBGpLogger.debug("getting variables for stackframe on line: " + this.lineNo);
        IVariable[] variables = ((DBGpTarget)this.getDebugTarget()).getVariables(this.stackLevel);
        return variables;
    }

    public boolean hasVariables() throws DebugException {
        IVariable[] variables = this.getVariables();
        return variables != null && variables.length > 0;
    }

    public boolean canStepInto() {
        return this.owningThread.canStepInto();
    }

    public boolean canStepOver() {
        return this.owningThread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.owningThread.canStepReturn();
    }

    public boolean isStepping() {
        return this.owningThread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.owningThread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.owningThread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.owningThread.stepReturn();
    }

    public boolean canResume() {
        return this.owningThread.canResume();
    }

    public boolean canSuspend() {
        return this.owningThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.owningThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.owningThread.resume();
    }

    public void suspend() throws DebugException {
        this.owningThread.suspend();
    }

    public boolean canTerminate() {
        return this.owningThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.owningThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.owningThread.terminate();
    }

    public String getSourceName() {
        return this.fileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBGpStackFrame) {
            DBGpStackFrame sf = (DBGpStackFrame)((Object)obj);
            try {
                boolean isEqual = sf.getQualifiedFile().equals(this.getQualifiedFile()) && sf.stackLevel.equals(this.stackLevel);
                return isEqual;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public int hashCode() {
        return this.getQualifiedFile().hashCode() + this.stackLevel.hashCode();
    }

    public String getQualifiedFile() {
        return this.qualifiedFile;
    }

    public String getStackLevel() {
        return this.stackLevel;
    }
}

